require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);


SliderFont = {
  standardFont,
  16,
  BlackColor
};


MakeDialog
{
	-- Name the modal dialog
	name="optionsmenu",
	Bitmap
	{
		image="ui/surfaces/panel",
		x = kCenter,
		y = kCenter,
		
		OptionsWindow
		{
			x=0,y=0,w=kMax,h=kMax,

			SetStyle(CreateTextStyle(FontGame, 30, RedColor)),
			Text
			{
				x=180,y=20,w=kMax,h=30,
				flags = kVAlignCenter + kHAlignLeft,
				label= "optionstitle",
			};
			
			SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
			Text
			{
				name = "sfx",
				x=80,y=82,w=50,h=50,
				label = "sfxlevel"
			};
		
		    SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
			Text
			{
				name = "music",
				x=80,y=152,w=50,h=50,
				label = "musiclevel"
			};

			SetStyle(CreateCheckButtonStyle(CheckboxButtonGraphics, DefaultButtonSound)),
			Button{
				name="fullscreen",
				x=75,
				y=215,
				w=150,
				SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
				Text
				{
					name = "fullscreenlabel",
					x=54,
					y=25,
					flags = kHAlignLeft + kVAlignTop,
					label="fullscreen",
				};
				command=
				function()
					if (ToggleFullScreen() == false) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="screenswitchfailed",
							title = "" 
						};
					end
				end
				
			};
			
			SetStyle(CreateCheckButtonStyle(CheckboxButtonGraphics, DefaultButtonSound)),
			Button{
				name="mutebox",
				x=250,
				y=215,
				w=175,
				SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
				Text
				{
					name = "mutesoundlabel",
					x=54,
					y=25,
					flags = kHAlignLeft + kVAlignTop,
					label="mutesound",
				};
				command =
					function()
						ToggleSoundMute();
					end
			};

			SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
			Button
			{
				x = kCenter-80,
				y = kMax-100,
				name="ok",
				command =
					function()
					    PlaySound("audio/sfx/menu/switch_screen.ogg");
						SaveVolumes();
						PopModal("optionsmenu");
					end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"ok", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"ok", 0, 0),
			},
			
			SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
			Button
			{
				x = kCenter+80,
				y = kMax-100,
				name="credits",
				command =
					function()
						DoModal("scripts/credits.lua");
					end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"credits", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"credits", 0, 0),
			},

			SetStyle(SliderStyle),
			Slider
			{
				name="sfxlevelslider",
				x = 135,
				y = 90,
				w = 270,
			};
			
			Slider
			{
				name="musiclevelslider",
				x = 135,
				y = 160,
				w = 270,
			};
		},
	},
}